﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace YumeNikkiRandomizer
{
    // Defines the location of a command.
    public abstract class CommandLocation
    {
        public CommandLocation()
        {
        }
    }
    
    // Defines the location of a command in a map.
    public class MapLocation : CommandLocation
    {
        public int mapID;
        public int eventID;
        public int page;
        public int commandNum;
        public string section;
        
        public MapLocation(int mapID, int eventID, int page = 1, int commandNum = 1, string section = "")
        {
            this.mapID = mapID;
            this.eventID = eventID;
            this.page = page;
            this.commandNum = commandNum;
            this.section = section;
        }
        public MapLocation(int mapID, int eventID, int page, string section)
        {
            this.mapID = mapID;
            this.eventID = eventID;
            this.page = page;
            this.commandNum = 1;
            this.section = section;
        }
    }
    
    // Defines the location of a command in a common event.
    public class CommonLocation : CommandLocation
    {
        public int eventID;
        public int commandNum;
        
        public CommonLocation(int eventID, int commandNum = 1)
        {
            this.eventID = eventID;
            this.commandNum = commandNum;
        }
    }
    
    // Defines multiple locations which are considered "the same"; that is, the same thing should go in all of them.
    public class CombinedLocation : CommandLocation
    {
        public List<CommandLocation> locations;
        
        public CombinedLocation()
        {
            locations = new List<CommandLocation>();
        }
        public CombinedLocation(params CommandLocation[] locations)
        {
            this.locations = new List<CommandLocation>();
            foreach (CommandLocation location in locations)
                this.locations.Add(location);
        }
    }
}
